/** NControlOHI.h -- Open Host Interface definitions 
 *
 *	(c) 2002, William H. Farr
 *
 *
 *	** OHI COMPONENT **
 *
 *  	08-May-2002		created						W.H.Farr
 *  	18-May-2002		last modified				W.H.Farr
 **/

#ifndef NCONTROL_OHI_H__
#define NCONTROL_OHI_H__

#include "MCiiDefs.h"
#include "MCiiEvts.h"


#define LogRecordSize	(2*sizeof(Word16))
#define NlogEntries		(EE_PARAMS/LogRecordSize)


/*-------+---------+---------+---------+---------|---------+---------+---------+---------+---------+
 *
 *		DEFAULT CALIBRATION CONSTANTS
 */

#define ADXL150_dn_per_G		 (498.0660)
#define ADLX150_zero		   (32768.0000)

#define MBAR_SEA				(1013.2500)
#define GRAD_K					 (0.006500)		// K / m
#define TEMP_SEA				( 298.1500)

#define MPX4100A_dn_per_mbar	   (69.4198)
#define MPX4100A_offset			(-9961.0000)
#define MPX4100A_zero		  	(MPX4100A_offset+(MBAR_SEA*MPX4100A_dn_per_mbar))

#define ADC12domain			(4095.)
#define DN1_5				(1.5/ADC12domain)
#define TempDegKslope		(1./0.00355)

#define AirGasConstant		0.03410			// K / m
#define EarthRadius			6378140.		// m
#define Gravity				9.80665			// m / s^2


/*-------+---------+---------+---------+---------|---------+---------+---------+---------+---------+
 *
 *		OHI PROTOCOL FSM COMMANDS
 */

#define OHI_clear_accu	'='
#define OHI_get_data	'?'
#define OHI_put_data	';'
#define OHI_read_accu	'#'
#define OHI_read_addr	':'
#define OHI_set_addr	'@'


/*
 *		ADC CHANNELS
 */

enum {
	iADCbat			= 'A',				// Vref = 1.5, atten = 8
	iADCacc,							// proportional (3.3V nom)
	iADCalt,							// proportional (3.3V nom)
	iADCtemp,							// Vref = 1.5, 3.55 mV/K
	iADCauxVds,							// Vref = 1.5, atten = 8
	iADCairVds,							// Vref = 1.5, atten = 8
	iADCpeakVds,						// Vref = 1.5, atten = 8
	iADCfloorVds,						// Vref = 1.5, atten = 8
	iADCaccAvg		= 'J',				// one second average
	iADCaltAvg							// one second average
 };


/*-------+---------+---------+---------+---------|---------+---------+---------+---------+---------+
 *
 *		EEPROM ADDRESSING & CONTROL
 *
 *	EEPROM addressing by WORD offset
 */

#define EEsetPage		(EE_SET >> 1)
#define EEfltPage		(EE_FLT >> 1)
#define EEstatesPage	(EE_STATES >> 1)


/*
 *		STATES SETUP EEPROM BLOCK
 */

typedef int iSTATES;

enum {
	iSTATESevt0		= EEstatesPage,		//  0: launch detect state
	iSTATESevt1,						//  1: event flags, state 1
	iSTATESevt2,						//  2: event flags, state 2
	iSTATESevt3,						//  3: event flags, state 3
	iSTATESevt4,						//  4: event flags, state 4
	iSTATESevt5,						//  5: event flags, state 5
	iSTATESevt6,						//  6: event flags, state 6
	iSTATESevt7,						//  7: event flags, state 7
	iSTATESevt8,						//  8: idle state
	iSTATESevt9,						//  9: unused state
	iSTATEStmr0,						// 10: no timeout for launch detect 
	iSTATEStmr1,						// 11: timeout ticks, state 1
	iSTATEStmr2,						// 12: timeout ticks, state 2
	iSTATEStmr3,						// 13: timeout ticks, state 3
	iSTATEStmr4,						// 14: timeout ticks, state 4
	iSTATEStmr5,						// 15: timeout ticks, state 5
	iSTATEStmr6,						// 16: timeout ticks, state 6
	iSTATEStmr7,						// 17: timeout ticks, state 7
	iSTATEStmr8,						// 18: no timeout for idle state
	iSTATEStmr9,						// 19: no timeout for unused state
	iSTATESled0,						// 20: led bits for launch detect 
	iSTATESled1,						// 21: led bits, state 1
	iSTATESled2,						// 22: led bits, state 2
	iSTATESled3,						// 23: led bits, state 3
	iSTATESled4,						// 24: led bits, state 4
	iSTATESled5,						// 25: led bits, state 5
	iSTATESled6,						// 26: led bits, state 6
	iSTATESled7,						// 27: led bits, state 7
	iSTATESled8,						// 28: no led bits for idle state
	iSTATESled9,						// 29: no idle bits for unused state
	iSTATEScheck,						// 30: self-test check flags
	iSTATESticks						// 31: self-test check timeout
 };


/*
 *		SET PARAMETERS EEPROM BLOCK
 */

typedef int iSET;

enum { 
	iSETflight		= EEsetPage, 		//  0: sequential flight number
	iSETunit,							//  1: unit serial identifier
	iSETaccCal_b,						//  2: acceleration calibration offset  (IEEE-32)
	iSETaccCal_b_hi,
	iSETaccCal_m,						//  4: acceleration calibration slope   (IEEE-32)
	iSETaccCal_m_hi,
	iSETaltCal_b,						//  6: altitude calibration offset      (IEEE-32)
	iSETaltCal_b_hi,
	iSETaltCal_m,						//  8: altitude calibration slope       (IEEE-32)
	iSETaltCal_m_hi,
	iSETlaunch,							// 10: detect acceleration threshold    (for EVT_acc_gt_threshold)
	iSETceiling,						// 11: pressure altitude ceiling        (for EVT_alt_gt_ceiling)
	iSETpeak,							// 12: pressure altitude apogee detect  (for EVT_alt_lt_peak)
	iSETfloor,							// 13: pressure altitude floor          (for EVT_alt_lt_floor)
	iSETlanded,							// 14: velocity lower threshold         (for EVT_vel_lt_threshold)
	iSETfalling,						// 15: velocity upper threshold         (for EVT_vel_gt_threshold)
	iSETtmrAir,							// 16: air state timeout
	iSETtmrPeak,						// 17: peak state timeout
	iSETtmrFloor,						// 18: floor state timeout
	iSETtmrAux,							// 19: aux fire timeout
	iSETcntAcc,							// 20: acceleration event debounce count
	iSETcntAlt,							// 21: altitude event debounce count
	iSETcntAux,							// 22: aux. switch event debounce count
	iSETcntVel,							// 23: velocity event debounce count
	iSET_24,							// 24: reserved
	iSET_25,							// 25: reserved
	iSET_26,							// 26: reserved
	iSET_27,							// 27: reserved
	iSETbatt,							// 28: minimum battery voltage at selftest
	iSETvers,							// 29: EE format version identifier 
	iSETkeyLO,							// 30: lo word for EE key
	iSETkeyHI,							// 31: hi word for EE key
 };


/*
 *		FLIGHT PARAMETERS EEPROM BLOCK
 */

typedef int iFLT;
				
enum {
	iFLTtmr			= EEfltPage,		//  0: flight timer
	iFLTtmr1,							//  1: event time 1
	iFLTtmr2,							//  2: event time 2
	iFLTtmr3,							//  3: event time 3
	iFLTtmr4,							//  4: event time 4
	iFLTtmr5,							//  5: event time 5
	iFLTtmr6,							//  6: event time 6
	iFLTtmr7,							//  7: event time 7
	iFLTtmr8,							//  8: event time 8
	iFLTtmr9,							//  9: event time 9
	iFLTvdsAir,							// 10: voltage at AIR fire
	iFLTvdsPeak,						// 11: voltage at PEAK fire
	iFLTvdsFloor,						// 12: voltage at FLOOR fire
	iFLTvdsAux,							// 13: voltage at AUX fire
	iFLT_14,							// 14: reserved
	iFLT_15,							// 15: reserved
	iFLTrefAlt,							// 16: launch reference pressure
	iFLTrefAcc,							// 17: launch reference acceleration
	iFLTtemp,							// 18: temperature at launch
	iFLTbatt,							// 19: battery voltage at launch
	iFLTee_beg,							// 20: EE word offset at launch
	iFLTee_end,							// 21: last used EE word offset
	iFLTpeakAlt,						// 22: peak flight altitude
	iFLT_23,							// 23: reserved
	iFLTtimeAir,						// 24: airstart time
	iFLTtimePeak,						// 25: peak fire time
	iFLTtimeFloor,						// 26: floor fire time
	iFLTtimeAux,						// 27: aux fire time
	iFLT_28,							// 28: reserved
	iFLT_29,							// 29: reserved
	iFLT_30,							// 30: reserved
	iFLTnum								// 31: flight number
 };


#endif	/* NCONTROL_OHI_H__ */
