/* MCiiEvts.h -- MissionControl II  MEC Event Definitions
 *
 *		(c) 2001-2002, William H. Farr
 *
 *	** OHI COMPONENT **
 *
 *  23-Dec-2001	created
 *  27-Apr-2002 last modified
 *
 *
 *  Common include file for both MCiiMEC and MControl app.
 *
 *       1         2         3         4         5         6         7         8
 *  5678901234567890123456789012345678901234567890123456789012345678901234567890
 */

/*
 *    GENERAL MODE FLAGS          [gMODEflags]
 */

#define MODE_enabled   0x01      /* enabled (one sec power on delay)    */

#define MODE_selftest  0x02      /* pre-flight init (NOT in host comm)  */
                                 /* means gSETblk, gFLTblk, */
                                 /*  and gSTATES have been initialized  */
                          
#define MODE_failed    0x04      /* failed self-test */
                                 /* only host comm is active until reset */
                              
#define MODE_active    0x08      /* active flight (pre-launch or in air) */
                                 /* means processing tick by state flags */

#define MODE_flight    0x10      /* in flight                  */
                                 /* set at launch detect       */
                                 /* reset at flight completion */
                              
#define MODE_inactive  0x20      /* set at flight completion             */
                                 /* can't write any more date to EEPROM  */
                                 /* only host comm is active until reset */

#define MODE_first     0x40      /* first step of peek/poke enable */

#define MODE_second    0x80      /* host comm peek/poke enabled */


/*
 *    SELF-TEST REQUEST FLAGS     [gCHKflags]
 */

#define CHK_vers       0x0001    /* display version */
#define CHK_batt       0x0002    /* check battery */
#define CHK_alt        0x0004    /* check altimeter */
#define CHK_acc        0x0008    /* check accelerometer */
#define CHK_aux_open   0x0010    /* require aux open at self-test */
#define CHK_air        0x0100    /* require air continuity at seft-test */
#define CHK_peak       0x0200    /* require peak continuity at seft-test */
#define CHK_floor      0x0400    /* require floor continuity at seft-test */
#define CHK_aux        0x0800    /* require aux continuity at seft-test */

#define FLG_feet       0x8000    /* blink peak altitude as feet */


/*
 *    STATE EVENT DETECT FLAGS    [gEVTflags]
 */

#define EVT_acc_gt_threshold    0x0001
#define EVT_acc_lt_zero         0x0002
#define EVT_vel_gt_threshold    0x0004
#define EVT_vel_lt_threshold    0x0008
#define EVT_vel_lt_zero         0x0010
#define EVT_alt_gt_ceiling      0x0020
#define EVT_alt_lt_peak         0x0040
#define EVT_alt_lt_floor        0x0080
#define EVT_aux_closed          0x0100
#define EVT_aux_opened          0x0200

#define Nstates         8


/*
 *  TIMER DEFINITIONS
 *
 *  Timer #0 is the flight timer
 *  The flight timer keeps count of ticks since launch detect
 *  Other timers mark flight events
 *
 *  timer trigger fields as:
 *
 *     1 1 1 1 1 1
 *     5 4 3 2 1 0 9 8 7 6 5 4 3 2 1 0     bit
 *     | | | | | | | | | | | | | | | |
 *     | | | | +-+-+-+-+-+-+-+-+-+-+-+-->  timer count
 *     | +-+-+-------------------------->  timer index, 0..7
 *     +-------------------------------->  latch trigger
 *
 *  timer range is 0..4095 sec at 16 Hz resolution
 *  trigger range is 0..255 sec at 16 Hz resolution
 */

#define TMR_BASE    0x7000
#define TMR_MODE    0x8000
#define TMR_TICK    0x0FFF

#define TMR_EVENT(x)    ((0x07 & x)<<12)
#define GET_EVENT(x)    ((x>>12) & 0x07)
