/* MCiiDefs -- MissionControl II MEC Common Defines
 *
 *		(c) 2001-2002, William H. Farr
 *
 *
 *	** OHI COMPONENT **
 *
 *	 02-Apr-2002 created
 *  17-May-2002 last modified
 *
 *
 *  Common include file for both MCiiMEC and NControl app.
 */


/* SAMPLE RATE */
#define Hz             1
#define TickRate     (16*Hz)
#define CalTicks     (10*TickRate)
#define PREINDEX     (CalTicks * 4)


/* SERIAL SETUP */
#define BAUDRATE    (57600)
#define DATABITS     8
#define ONESTOP      0
#define PARITYBIT    NOPARITY
#define STOPBITS     ONESTOP

/* TRIGGER INDICIES */
#define AirCh     0
#define PeakCh    1
#define FloorCh   2
#define AuxCh     3

/* EEPROM MAP */
#define EEPROM_SIZE        32768
#define EE_PAGE_SIZE          64
#define EE_SET             (EEPROM_SIZE - (1*EE_PAGE_SIZE))
#define EE_FLT             (EEPROM_SIZE - (2*EE_PAGE_SIZE))
#define EE_STATES          (EEPROM_SIZE - (3*EE_PAGE_SIZE))
#define EE_PARAMS          (EE_STATES)

#define FLT_SZ          EE_PAGE_SIZE
#define SET_SZ          EE_PAGE_SIZE
#define STATES_SZ       EE_PAGE_SIZE
